/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.Application;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationsResponse;

public class ListApplicationsIterable
implements SdkIterable<ListApplicationsResponse> {
    private final SsoAdminClient client;
    private final ListApplicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationsIterable(SsoAdminClient client, ListApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationsResponseFetcher();
    }

    @Override
    public Iterator<ListApplicationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Application> applications() {
        Function<ListApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.applications() != null) {
                return response.applications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListApplicationsResponseFetcher
    implements SyncPageFetcher<ListApplicationsResponse> {
        private ListApplicationsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListApplicationsResponse nextPage(ListApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationsIterable.this.client.listApplications(ListApplicationsIterable.this.firstRequest);
            }
            return ListApplicationsIterable.this.client.listApplications((ListApplicationsRequest)ListApplicationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

