/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.InstanceMetadata;
import software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse;

public class ListInstancesIterable
implements SdkIterable<ListInstancesResponse> {
    private final SsoAdminClient client;
    private final ListInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInstancesIterable(SsoAdminClient client, ListInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInstancesResponseFetcher();
    }

    @Override
    public Iterator<ListInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceMetadata> instances() {
        Function<ListInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instances() != null) {
                return response.instances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListInstancesResponseFetcher
    implements SyncPageFetcher<ListInstancesResponse> {
        private ListInstancesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListInstancesResponse nextPage(ListInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListInstancesIterable.this.client.listInstances(ListInstancesIterable.this.firstRequest);
            }
            return ListInstancesIterable.this.client.listInstances((ListInstancesRequest)ListInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

