/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.AttachedManagedPolicy;
import software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse;

public class ListManagedPoliciesInPermissionSetPublisher
implements SdkPublisher<ListManagedPoliciesInPermissionSetResponse> {
    private final SsoAdminAsyncClient client;
    private final ListManagedPoliciesInPermissionSetRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListManagedPoliciesInPermissionSetPublisher(SsoAdminAsyncClient client, ListManagedPoliciesInPermissionSetRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListManagedPoliciesInPermissionSetPublisher(SsoAdminAsyncClient client, ListManagedPoliciesInPermissionSetRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListManagedPoliciesInPermissionSetResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListManagedPoliciesInPermissionSetResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AttachedManagedPolicy> attachedManagedPolicies() {
        Function<ListManagedPoliciesInPermissionSetResponse, Iterator> getIterator = response -> {
            if (response != null && response.attachedManagedPolicies() != null) {
                return response.attachedManagedPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListManagedPoliciesInPermissionSetResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListManagedPoliciesInPermissionSetResponseFetcher
    implements AsyncPageFetcher<ListManagedPoliciesInPermissionSetResponse> {
        private ListManagedPoliciesInPermissionSetResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListManagedPoliciesInPermissionSetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListManagedPoliciesInPermissionSetResponse> nextPage(ListManagedPoliciesInPermissionSetResponse previousPage) {
            if (previousPage == null) {
                return ListManagedPoliciesInPermissionSetPublisher.this.client.listManagedPoliciesInPermissionSet(ListManagedPoliciesInPermissionSetPublisher.this.firstRequest);
            }
            return ListManagedPoliciesInPermissionSetPublisher.this.client.listManagedPoliciesInPermissionSet((ListManagedPoliciesInPermissionSetRequest)ListManagedPoliciesInPermissionSetPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

