/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse;

public class ListPermissionSetsIterable
implements SdkIterable<ListPermissionSetsResponse> {
    private final SsoAdminClient client;
    private final ListPermissionSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPermissionSetsIterable(SsoAdminClient client, ListPermissionSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPermissionSetsResponseFetcher();
    }

    @Override
    public Iterator<ListPermissionSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> permissionSets() {
        Function<ListPermissionSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.permissionSets() != null) {
                return response.permissionSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListPermissionSetsResponseFetcher
    implements SyncPageFetcher<ListPermissionSetsResponse> {
        private ListPermissionSetsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListPermissionSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListPermissionSetsResponse nextPage(ListPermissionSetsResponse previousPage) {
            if (previousPage == null) {
                return ListPermissionSetsIterable.this.client.listPermissionSets(ListPermissionSetsIterable.this.firstRequest);
            }
            return ListPermissionSetsIterable.this.client.listPermissionSets((ListPermissionSetsRequest)ListPermissionSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

