/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.auth.token.credentials.SdkToken;
import software.amazon.awssdk.auth.token.credentials.SdkTokenProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.token.CachedTokenRefresher;
import software.amazon.awssdk.awscore.internal.token.TokenManager;
import software.amazon.awssdk.awscore.internal.token.TokenRefresher;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.ssooidc.SsoOidcClient;
import software.amazon.awssdk.services.ssooidc.internal.OnDiskTokenManager;
import software.amazon.awssdk.services.ssooidc.internal.SsoOidcToken;
import software.amazon.awssdk.services.ssooidc.internal.SsoOidcTokenTransformer;
import software.amazon.awssdk.services.ssooidc.model.CreateTokenRequest;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
public final class SsoOidcTokenProvider
implements SdkTokenProvider,
SdkAutoCloseable {
    private static final Duration DEFAULT_STALE_DURATION = Duration.ofMinutes(1L);
    private static final Duration DEFAULT_PREFETCH_DURATION = Duration.ofMinutes(5L);
    private static final Logger log = Logger.loggerFor(SsoOidcTokenProvider.class);
    private final TokenManager<SsoOidcToken> onDiskTokenManager;
    private final TokenRefresher<SsoOidcToken> tokenRefresher;
    private final SsoOidcClient ssoOidcClient;
    private final Duration staleTime;
    private final Duration prefetchTime;

    private SsoOidcTokenProvider(BuilderImpl builder) {
        Validate.paramNotNull(builder.sessionName, "sessionName");
        Validate.paramNotNull(builder.ssoOidcClient, "ssoOidcClient");
        this.ssoOidcClient = builder.ssoOidcClient;
        this.staleTime = builder.staleTime == null ? DEFAULT_STALE_DURATION : builder.staleTime;
        this.prefetchTime = builder.prefetchTime == null ? DEFAULT_PREFETCH_DURATION : builder.prefetchTime;
        this.onDiskTokenManager = OnDiskTokenManager.create(builder.sessionName);
        this.tokenRefresher = CachedTokenRefresher.builder().tokenRetriever(SsoOidcTokenProvider.getDefaultSsoTokenRetriever(this.ssoOidcClient, this.onDiskTokenManager, this.staleTime, this.prefetchTime)).exceptionHandler(this.exceptionHandler()).prefetchTime(this.prefetchTime).staleDuration(this.staleTime).asyncRefreshEnabled(builder.asyncTokenUpdateEnabled).build();
    }

    private Function<SdkException, SsoOidcToken> exceptionHandler() {
        return e -> {
            if (e instanceof AwsServiceException) {
                log.warn(() -> "Failed to fetch token.", (Throwable)e);
                return this.onDiskTokenManager.loadToken().orElseThrow(() -> SdkClientException.create("Unable to load SSO token"));
            }
            throw e;
        };
    }

    @Override
    public SdkToken resolveToken() {
        SsoOidcToken ssoOidcToken = this.tokenRefresher.refreshIfStaleAndFetch();
        if (this.isExpired(ssoOidcToken)) {
            throw SdkClientException.create("Token is expired");
        }
        return ssoOidcToken;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void close() {
        this.tokenRefresher.close();
    }

    private boolean isExpired(SsoOidcToken token) {
        Instant expiration = token.expirationTime().get();
        Instant now = Instant.now();
        return now.isAfter(expiration);
    }

    private static boolean isWithinRefreshWindow(SsoOidcToken token, Duration staleTime) {
        Instant expiration = token.expirationTime().get();
        Instant now = Instant.now();
        return expiration.isAfter(now.plus(staleTime));
    }

    private static void validateToken(SsoOidcToken token) {
        Validate.notNull(token.token(), "token cannot be null", new Object[0]);
        Validate.notNull(token.expirationTime(), "expirationTime cannot be null", new Object[0]);
    }

    private static Supplier<SsoOidcToken> getDefaultSsoTokenRetriever(SsoOidcClient ssoOidcClient, TokenManager<SsoOidcToken> tokenManager, Duration staleTime, Duration prefetchTime) {
        return () -> {
            SsoOidcToken baseToken = (SsoOidcToken)tokenManager.loadToken().orElseThrow(() -> SdkClientException.create("Unable to load SSO token"));
            SsoOidcTokenProvider.validateToken(baseToken);
            if (SsoOidcTokenProvider.isWithinRefreshWindow(baseToken, staleTime) && SsoOidcTokenProvider.isWithinRefreshWindow(baseToken, prefetchTime)) {
                return baseToken;
            }
            SsoOidcTokenTransformer ssoOidcTokenTransformer = SsoOidcTokenTransformer.create(baseToken);
            SsoOidcToken refreshToken = ssoOidcTokenTransformer.transform(ssoOidcClient.createToken((CreateTokenRequest)CreateTokenRequest.builder().grantType("refresh_token").clientId(baseToken.clientId()).clientSecret(baseToken.clientSecret()).refreshToken(baseToken.refreshToken()).build()));
            tokenManager.storeToken(refreshToken);
            return refreshToken;
        };
    }

    private static class BuilderImpl
    implements Builder {
        private String sessionName;
        private SsoOidcClient ssoOidcClient;
        private Duration staleTime;
        private Duration prefetchTime;
        private Boolean asyncTokenUpdateEnabled = false;

        private BuilderImpl() {
        }

        @Override
        public Builder sessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        @Override
        public Builder ssoOidcClient(SsoOidcClient ssoOidcClient) {
            this.ssoOidcClient = ssoOidcClient;
            return this;
        }

        @Override
        public Builder staleTime(Duration staleTime) {
            this.staleTime = staleTime;
            return this;
        }

        @Override
        public Builder prefetchTime(Duration prefetchTime) {
            this.prefetchTime = prefetchTime;
            return this;
        }

        @Override
        public Builder asyncTokenUpdateEnabled(Boolean asyncTokenUpdateEnabled) {
            this.asyncTokenUpdateEnabled = asyncTokenUpdateEnabled;
            return this;
        }

        @Override
        public SsoOidcTokenProvider build() {
            return new SsoOidcTokenProvider(this);
        }
    }

    public static interface Builder {
        public Builder sessionName(String var1);

        public Builder ssoOidcClient(SsoOidcClient var1);

        public Builder staleTime(Duration var1);

        public Builder prefetchTime(Duration var1);

        public Builder asyncTokenUpdateEnabled(Boolean var1);

        public SsoOidcTokenProvider build();
    }
}

