/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.ssooidc.model.SsoOidcException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvalidRequestRegionException
extends SsoOidcException
implements ToCopyableBuilder<Builder, InvalidRequestRegionException> {
    private static final SdkField<String> ERROR_FIELD = SdkField.builder(MarshallingType.STRING).memberName("error").getter(InvalidRequestRegionException.getter(InvalidRequestRegionException::error)).setter(InvalidRequestRegionException.setter(Builder::error)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder(MarshallingType.STRING).memberName("endpoint").getter(InvalidRequestRegionException.getter(InvalidRequestRegionException::endpoint)).setter(InvalidRequestRegionException.setter(Builder::endpoint)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("region").getter(InvalidRequestRegionException.getter(InvalidRequestRegionException::region)).setter(InvalidRequestRegionException.setter(Builder::region)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();
    private static final SdkField<String> ERROR_DESCRIPTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("errorDescription").getter(InvalidRequestRegionException.getter(InvalidRequestRegionException::errorDescription)).setter(InvalidRequestRegionException.setter(Builder::errorDescription)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error_description").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD, ENDPOINT_FIELD, REGION_FIELD, ERROR_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvalidRequestRegionException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String error;
    private final String endpoint;
    private final String region;
    private final String errorDescription;

    private InvalidRequestRegionException(BuilderImpl builder) {
        super(builder);
        this.error = builder.error;
        this.endpoint = builder.endpoint;
        this.region = builder.region;
        this.errorDescription = builder.errorDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public String error() {
        return this.error;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String region() {
        return this.region;
    }

    @Deprecated
    public String error_description() {
        return this.errorDescription;
    }

    public String errorDescription() {
        return this.errorDescription;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("error", ERROR_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("region", REGION_FIELD);
        map.put("error_description", ERROR_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvalidRequestRegionException, T> g) {
        return obj -> g.apply((InvalidRequestRegionException)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoOidcException.BuilderImpl
    implements Builder {
        private String error;
        private String endpoint;
        private String region;
        private String errorDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidRequestRegionException model) {
            super(model);
            this.error(model.error);
            this.endpoint(model.endpoint);
            this.region(model.region);
            this.errorDescription(model.errorDescription);
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getErrorDescription() {
            return this.errorDescription;
        }

        public final void setErrorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
        }

        @Deprecated
        public final void setError_description(String errorDescription) {
            this.errorDescription = errorDescription;
        }

        @Override
        public final Builder errorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        @Override
        public final Builder error_description(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public InvalidRequestRegionException build() {
            return new InvalidRequestRegionException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvalidRequestRegionException>,
    SsoOidcException.Builder {
        public Builder error(String var1);

        public Builder endpoint(String var1);

        public Builder region(String var1);

        public Builder errorDescription(String var1);

        @Deprecated
        public Builder error_description(String var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);

        @Override
        public Builder numAttempts(Integer var1);
    }
}

